/**************************************************************************/
/*                                                                        */
/* Header file:        INTSRV.H                                           */
/*                                                                        */
/* Function:           Interactive Service Interface -- Header file       */
/*                                                                        */
/* Author:             W. Reichert, D.3228                                */
/*                                                                        */
/* Date created:       1990-10-20                                         */
/*                                                                        */
/* Classification:     IBM Internal Use Only                              */
/*                                                                        */
/**************************************************************************/

/**************************************************************************/
/* Define directives: Value types                                         */
/**************************************************************************/

                               /**** VALUE VARIABLES **********************/
#define TYPE_VOID       0      /* Undefined (reserved)                    */
#define TYPE_BOOL       1      /* Boolean (0 = FALSE or 1 = TRUE)         */
#define TYPE_CHAR       2      /* Signed character (1 byte)               */
#define TYPE_UCHAR      3      /* Unsigned character (1 byte)             */
#define TYPE_SHORT      4      /* Signed short integer (2 bytes)          */
#define TYPE_USHORT     5      /* Unsigned short integer (2 bytes)        */
#define TYPE_LONG       6      /* Signed long integer (4 bytes)           */
#define TYPE_ULONG      7      /* Unsigned long integer (4 bytes)         */
#define TYPE_ACHAR      8      /* Array of characters                     */
#define TYPE_ACHARZ     9      /* Array of characters - zero-terminated   */

                               /**** POINTER VARIABLES ********************/
#define TYPE_PSZ       10      /* Pointer to zero-terminated string       */
#define TYPE_PCHAR     11      /* Pointer to character buffer             */
#define TYPE_PVOID     12      /* Pointer                                 */
#define TYPE_PFUNCTION 13      /* Pointer to function name (reserved)     */

                               /**** OS/2 SPECIFIC TYPES ******************/
#define TYPE_SHANDLE   TYPE_USHORT
#define TYPE_LHANDLE   TYPE_ULONG
#define TYPE_BYTE      TYPE_UCHAR
#define TYPE_PBYTE     TYPE_PCHAR
#define TYPE_SEL       TYPE_USHORT
#define TYPE_ERRORID   TYPE_ULONG
#define TYPE_HSEM      TYPE_PVOID
#define TYPE_HAB       TYPE_LHANDLE
#define TYPE_HMQ       TYPE_LHANDLE
#define TYPE_HPS       TYPE_LHANDLE
#define TYPE_HDC       TYPE_LHANDLE
#define TYPE_HRGN      TYPE_LHANDLE
#define TYPE_HBITMAP   TYPE_LHANDLE
#define TYPE_HMF       TYPE_LHANDLE
#define TYPE_COLOR     TYPE_LONG
#define TYPE_FIXED     TYPE_LONG
#define TYPE_HWND      TYPE_ULONG
#define TYPE_PFN       TYPE_PVOID
#define TYPE_PFNWP     TYPE_PVOID
#define TYPE_MPARAM    TYPE_ULONG
#define TYPE_MRESULT   TYPE_ULONG

                                       /***** MACHINE-DEPENDENT TYPES *****/
 
#ifdef __32BIT__                       /* *** 32 BIT ***                  */
#define TYPE_INT       TYPE_LONG       /* Signed integer (= LONG)         */
#define TYPE_UINT      TYPE_ULONG      /* Unsigned integer (= ULONG)      */
#define TYPE_HMODULE   TYPE_LHANDLE
#define TYPE_PID       TYPE_LHANDLE
#define TYPE_TID       TYPE_LHANDLE
 
#else                                  /* *** 16 BIT ***                  */
#define TYPE_INT       TYPE_SHORT      /* Signed integer (= SHORT)        */
#define TYPE_UINT      TYPE_USHORT     /* Unsigned integer (= USHORT)     */
#define TYPE_HMODULE   TYPE_USHORT
#define TYPE_PID       TYPE_USHORT
#define TYPE_TID       TYPE_USHORT
#endif


/**************************************************************************/
/* Define directives: Options for GetValue(), ShowValue(), SetValueSize() */
/**************************************************************************/

                               /* Options for GetValue(), ShowValue():    */
#define DISPLAY_STANDARD  0x00 /* Integers: decimal                       */
                               /*   except CHAR/UCHAR: 'c'                */
                               /* Strings: "..." #length                  */
#define DISPLAY_HEX       0x01 /* Integers: 0x..., Strings: x'...'        */
#define DISPLAY_INTEGER   0x02 /* Integers: decimal              ( syno-  */
#define DISPLAY_LENGTH    0x02 /* Strings: #length (length only) ( nym    */

                               /* Options for ShowValue():                */
#define NO_SETVALUE       0x10 /* Don't save the value in the INTSRV pool */
#define NO_SETVALUE_IF_0  0x20 /* Don't save the value ... if it is zero  */

                               /* Options for GetValue(), SetValueSize(): */
#define CLEAR_BUFFER      0x40 /* Clear the variable buffer               */

                               /* Options for GetValue():                 */
#define NO_PROMPT       0x0100 /* Don't prompt the user for input         */
#define NO_WRITE        0x0200 /* Don't write the user input to file/cons */

/**************************************************************************/
/* External entry points                                                  */
/**************************************************************************/

USHORT EXPENTRY INTSRV(
    PSZ  pszIdentName,         /* i:  Identification name (or NULL)       */
    PSZ  pszInitMsg);          /* i:  Initialization message (or NULL)    */
                               /* RC: Set via SetRC() on error or         */
                               /*     through "Return" function           */

/**************************************************************************/
/* Additional external entry points  (for ScreenView)                     */
/**************************************************************************/

#ifdef __32BIT__
 
  #ifdef SCREENVIEW
    #define BUSAPIENTRY APIENTRY16
  #else
    #define BUSAPIENTRY EXPENTRY
  #endif
  typedef char *      HPCHAR;
 
#else /* 16BIT */
 
  #define BUSAPIENTRY EXPENTRY
  typedef char huge * HPCHAR;
 
#endif

                               /*** Calling as function program ***********/
USHORT BUSAPIENTRY INTSRV_FP(VOID);
                               /* RC: Return code of INTSRV()             */

                               /**** Calling as checking logic ************/
USHORT BUSAPIENTRY INTSRV_CL(
    LONG      lVTHandle,       /* i:  VT Handle                           */
    PSZ       pszCommUnit);    /* i:  Communication Unit                  */
                               /* RC: Return code of INTSRV()             */

                               /**** Calling as presentation front end ****/
USHORT BUSAPIENTRY INTSRV_PFE(
    LONG      lVTHandle,       /* i:  VT Handle                           */
    PSZ       pszCommUnit,     /* i:  Communication Unit                  */
    CHAR      chRequest);      /* i:  Request                             */
                               /* RC: Return code of INTSRV()             */

                               /**** Calling as generic data access *******/
MRESULT BUSAPIENTRY INTSRV_GDA(
    LHANDLE   This,            /* i:  GenOVHa object handle               */
    USHORT    Msg,             /* i:  GenOVHa message                     */
    MPARAM    Mp1,             /* i/o:Input/Output carrier                */
    MPARAM    Mp2);            /* i:  GenOVHa information carrier         */
                               /* RC: 0: Success | 1L: Error              */

                               /**** Calling as layout routine ************/
MRESULT BUSAPIENTRY INTSRV_LAY(
    LHANDLE   Area,            /* i:  GenOVHa area handle                 */
    USHORT    Msg,             /* i:  GenOVHa message                     */
    MPARAM    Mp1,             /* i/o:Input/Output carrier                */
    MPARAM    Mp2);            /* i:  GenOVHa information carrier         */

                               /**** Calling as help exit *****************/
USHORT BUSAPIENTRY INTSRV_HLPX(
    LONG      lVTHandle,       /* i:  VT Handle                           */
    PSZ       pszCommUnit,     /* i:  Communication Unit                  */
    PSZ       pszHelpFile,     /* i:  Help file                           */
    PUSHORT   pusHelpID);      /* i/o:Help ID                             */
               
                               /**** Calling as environment routine *******/
USHORT BUSAPIENTRY INTSRV_ENV(
    PVOID     pEnvAddr,        /* i:  Environment pointer (*obsolete*)    */
    PCHAR     pchData,         /* i:  Data                                */
    ULONG     ulDataLen);      /* i:  Length of data                      */

                               /**** Calling as remote function ***********/
LONG INTSRV_RF(
    HPCHAR    hpInputBuf,      /* i:  Input Buffer                        */
    ULONG    *pulInputBufLen,  /* i:  Length of input buffer              */
    HPCHAR    hpOutputBuf,     /* o:  Output Buffer                       */
    ULONG    *pulOutputBufLen);/* i/o:Length of output buffer             */
                               /* RC: Return code (LONG!)                 */

/**************************************************************************/
/* Function prototypes and macros                                         */
/**************************************************************************/

#define GetValue(T,N,pV,pL,O)  while(GetValue_(T,N,pV,pL,O)) return 1

USHORT GetValue_(
    INT       iType,           /* i:   Data type as defined above         */
    PSZ       pszName,         /* i:   Name of the input variable         */
    PVOID     pValue,          /* o:   Pointer to actual value            */
    PULONG    pulLength,       /* i/o: String/buffer length (PCHAR, ...)  */
    USHORT    fOption);        /* i:   Options as defined above           */
                               /* RC:  0 = OK  |  1 = Error               */

#define SetValue(T,N,pV,L,O)   while(SetValue_(T,N,pV,L,O)) return 1

USHORT SetValue_(
    INT       iType,           /* i:   Data type as defined above         */
    PSZ       pszName,         /* i:   Name of the input variable         */
    PVOID     pValue,          /* i:   Pointer to actual value            */
    ULONG     ulLength,        /* i:   Buffer length (for PCHAR, PSZ, ...)*/
    USHORT    fOption);        /* i:   Options as defined above           */
                               /* RC:  0 = OK  |  1 = Error               */

#define SetValueSize(T,N,pV,L,F,O)  while(SetValueSize_(T,N,pV,L,F,O)) return 1

USHORT SetValueSize_(
    INT       iType,           /* i:   Data type as defined above         */
    PSZ       pszName,         /* i:   Name of the input variable         */
    PVOID     pValue,          /* o:   Pointer to re-sized buffer         */
    ULONG     ulLength,        /* i:   Desired buffer length              */
    CHAR      chFiller,        /* i:   Fill character                     */
    USHORT    fOption);        /* i:   Options as defined above           */
                               /* RC:  0 = OK  |  1 = Error               */

#define ShowValue(T,N,pV,L,O)  while(ShowValue_(T,N,pV,L,O)) return 1

USHORT ShowValue_(
    INT       iType,           /* i:   Data type as defined above         */
    PSZ       pszName,         /* i:   Name of the input variable         */
    PVOID     pValue,          /* i:   Pointer to actual value            */
    ULONG     ulLength,        /* i:   Buffer length (for PCHAR, PSZ, ...)*/
    USHORT    fOption);        /* i:   Options as defined above           */
                               /* RC:  0 = OK  |  1 = Error               */

#define GetBuffer(pV,NL,OL)    while(GetBuffer_(pV,NL,OL)) return 1

USHORT GetBuffer_(
    PVOID     pValue,          /* i/o: Pointer to current buffer address  */
    ULONG     ulNewLength,     /* i:   New buffer length                  */
    ULONG     ulOldLength);    /* i:   Old buffer length (if old value    */
                               /*        should be retained)              */
                               /* RC:  0 = OK  |  1 = Error               */

USHORT ShowMsg(
    CHAR      chSev,           /* i:   Msg severity: I | W | Q | E        */
    PSZ       pszText, ...);   /* i:   Variable number of arguments       */
                               /*        (used like printf)               */
                               /* RC:  0 = OK  |  1 = CANCEL              */

VOID SetRC(
    USHORT usRC);              /* i:    Set final return code             */

/**************************************************************************/
/* Macro for conditional sections                                         */
/**************************************************************************/

extern  BOOL ISI_fCondSect;    /* Switch for conditional sections         */
extern  PSZ  ISI_msgCondSect;  /* Message texts for conditional sections  */
extern  PSZ  ISI_msgAltSect;
extern  PSZ  ISI_msgECondSect;
extern  PSZ  ISI_msgEAltSect;
extern  PSZ  ISI_msgSkipSect;

#define CONDSECT_MON  (BOOL) 0x01  /* Values of ISI_fCondSect: Monitor    */
#define CONDSECT_SKIP (BOOL) 0x02  /*   and/or skip conditional sections  */

#define COND_SECT(NAME) {\
          PSZ  ISI_CSName = NAME;\
          BOOL ISI_CSMon  = ISI_fCondSect & CONDSECT_MON;\
          BOOL ISI_CSSkip = ISI_fCondSect & CONDSECT_SKIP;\
          BOOL ISI_CSAlt  = FALSE;\
          if (ISI_CSMon && !ISI_CSSkip)\
          ShowMsg('I', ISI_msgCondSect, ISI_CSName);\
          if (!ISI_CSSkip) {

#define ALT_COND_SECT }\
          else {\
            ISI_CSAlt = TRUE;\
            ShowMsg('I', ISI_msgAltSect, ISI_CSName);

#define END_COND_SECT }\
          if (ISI_CSMon)\
            if (!ISI_CSSkip)\
              ShowMsg('I', ISI_msgECondSect, ISI_CSName);\
            else if (ISI_CSAlt)\
              ShowMsg('I', ISI_msgEAltSect, ISI_CSName);\
            else\
              ShowMsg('I', ISI_msgSkipSect, ISI_CSName);\
        }

/**************************************************************************/
/* Miscellaneous macros                                                   */
/**************************************************************************/

#define GetOutBuf(iBufType,pszBufName,ppBuffer,pBufLen,iLenType,pszLenName,pLength) \
        { \
          GetValue(iBufType, pszBufName, ppBuffer, pBufLen, \
                   CLEAR_BUFFER | DISPLAY_LENGTH); \
          SetValue(iLenType, pszLenName, pBufLen, 0L, 0); \
          GetValue(iLenType, pszLenName, pLength, 0, 0); \
          if ((ULONG) *(pLength) > *(pBufLen)) \
            if (ShowMsg('Q', "%s is greater than size of %s", \
                        pszLenName, pszBufName)) \
              return 1; \
        }

#define GetInBuf(iBufType,pszBufName,ppBuffer,pBufLen,iLenType,pszLenName,pLength) \
        { \
          GetValue(iBufType, pszBufName, ppBuffer, pBufLen, 0); \
          SetValue(iLenType, pszLenName, pBufLen, 0L, 0); \
          GetValue(iLenType, pszLenName, pLength, 0, 0); \
          if ((ULONG) *(pLength) > *(pBufLen)) \
            if (ShowMsg('Q', "%s is greater than size of %s", \
                        pszLenName, pszBufName)) \
              return 1; \
        }

/**************************************************************************/
/* Structure definition ISI_FUNC:                                         */
/* The structure contains all defined function names and function point-  */
/* ers. The structure is filled by INTS_INI.H and is used internally only.*/
/**************************************************************************/

typedef struct
{
    PSZ    pszFuncName;        /* Function name as specified by the user  */
    USHORT (*Function)(VOID);  /* Function address (entry point)          */
} ISI_FUNC;

extern ISI_FUNC ISI_astuFunctions[];
